IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.[CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

	/***************************************************************************************************

	Procedimiento:      dbo.CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items
	Fecha de Creacion:  2023-08-09
	Creado por:         Florencia Gonzalez
	Descripcion:        Procedimiento encargado de dividir operaciones a informar a entidad 
						(lote de tarjetas de debito/credito)
	Llamado por:        Lotes:Tarjetas:Fac:Dividir (FSER.APP ERP Desktop)
	Tablas afectadas:   [Val_Tarjetas_Lotes],[Val_Tarjetas_Lotes_Items]
	Usado en:           Administrador de Lotes de Tarjetas de Créditos y Centros de Pago (menú Facturación y Cobranzas)
	Parametro(s):       FlagUsarTrans, ModoDebug, Id_Tar_Lote, Max_Importe, Omitir_Resultado_OK
	Forma de uso:       EXEC [dbo].[CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items] '{"Id_Tar_Lote":"60","Max_Importe":"100000","FlagUsarTrans":"1","ModoDebug":"0","Omitir_Resultado_OK":"0"}'
	Notas adicionales:  

	****************************************************************************************************

	SUMARIO DE CAMBIOS
	FECHA(yyyy-mm-dd)    Autor              Comentarios
	------------------- ------------------- ------------------------------------------------------------
              
	***************************************************************************************************/

	-------------------------------------------- VARIABLES RECIBIDAS POR PARAM --------------------------------------------

	DECLARE @pFlagUsarTrans			TINYINT
	DECLARE @pModoDebug				TINYINT
	DECLARE @pId_Tar_Lote			SMALLINT
	DECLARE @pMax_Importe			INT
	DECLARE @pOmitir_Resultado_OK	TINYINT

	SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
	SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
	SET @pId_Tar_Lote				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Tar_Lote')), 0)
	SET @pMax_Importe				= ISNULL(CONVERT(DECIMAL(20,2), dbo.CF_JSON_VALUE(@pJson,'Max_Importe')), 0)
	SET @pOmitir_Resultado_OK		= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Omitir_Resultado_OK')), 0)

	-------------------------------------------- FIN VARIABLES RECIBIDAS POR PARAM --------------------------------------------

	-------------------------------------------- VARIABLES LOCALES --------------------------------------------

	DECLARE @Cant_Items_Divididos	INT
	DECLARE @Item_Dividir			INT
	DECLARE @Prox_Item				INT
	DECLARE @Importe				DECIMAL(12,2)
	DECLARE @Importe2				DECIMAL(12,2)
	DECLARE @Importe3				DECIMAL(12,2)

	DECLARE @Respuesta_ TABLE (
								ErrorNumber		INT,
								ErrorSeverity	INT,
								ErrorState		INT,
								ErrorProcedure  VARCHAR(1000),
								ErrorLine		INT,
								ErrorMessage	VARCHAR(1000)
							  )

	DECLARE @Items_Dividir TABLE (
									Id_Tar_Lote			INT,
									Item_Tar_Lote		INT,
									Id_Cliente			INT,
									Id_Trans			INT,
									Nro					VARCHAR(50),
									Descripcion			VARCHAR(50),
									Importe				DECIMAL(15,5),
									Estado				CHAR(1),
									Nota					VARCHAR(250),
									CUIT					VARCHAR(50),
									Fecha_Est				DATETIME,
									Importe_2Vto			DECIMAL(15,5),
									Importe_3Vto			DECIMAL(15,5),
									Item_Tabla			SMALLINT NOT NULL IDENTITY(1,1)
								  )

	-------------------------------------------- FIN VARIABLES LOCALES --------------------------------------------

BEGIN TRY
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items'
		PRINT 'Parametros:'
		PRINT 'pModoDebug: ' + CONVERT(VARCHAR(5), @pModoDebug) + '. pId_Tar_Lote: ' + CONVERT(VARCHAR(15),@pId_Tar_Lote) 
	END

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END
	
	IF ISNULL((SELECT Id_Tar_Lote FROM Val_Tarjetas_Lotes WHERE Id_Tar_Lote = @pId_Tar_Lote),0) = 0
	BEGIN
		INSERT INTO @Respuesta_ (ErrorNumber,ErrorMessage)
						VALUES(1,'El lote de tarjetas ' + CONVERT(VARCHAR(15),@pId_Tar_Lote) + ' no existe')
		RAISERROR ('Error al ejecutar CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items', 16, 1)
	END

	IF (SELECT COUNT(*) FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote) = 0
	BEGIN
		INSERT INTO @Respuesta_ (ErrorNumber,ErrorMessage)
						  VALUES(2,'El lote de tarjetas ' + CONVERT(VARCHAR(15),@pId_Tar_Lote) + ' no tiene items')
		RAISERROR ('Error al ejecutar CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items', 16, 1)
	END

	IF (SELECT COUNT(*) FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote AND Importe > @pMax_Importe) = 0
	BEGIN
		INSERT INTO @Respuesta_ (ErrorNumber,ErrorMessage)
						  VALUES(3,'No hay items en este lote de tarjetas que excedan el importe de ' +  CONVERT(VARCHAR(25),@pMax_Importe))
		RAISERROR ('Error al ejecutar CPJ_Val_Tarjetas_Lotes_Items_Dividir_Items', 16, 1)
	END
	
	--------------------------------------------- CALCULO ITEMS A SEPARAR --------------------------------------

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Genero tabla auxiliar con los items que exceden el maximo importe' 
	END


	INSERT INTO @Items_Dividir
		SELECT Id_Tar_Lote, Item, Id_Cliente, Id_Trans, Nro, Descripcion, Importe, Estado, Nota, Cuit, Fecha_Est, Importe_2Vto, Importe_3Vto 
			   FROM Val_Tarjetas_Lotes_Items
			   WHERE Id_Tar_Lote = @pId_Tar_Lote
			     AND Importe > @pMax_Importe

	-------------------------------------------- FIN CALCULO ITEMS A SEPARAR -----------------------------------


	--------------------------------------------- SEPARO LOS ITEMS  --------------------------------------------
	
	SET @Cant_Items_Divididos = 0

	WHILE(@Cant_Items_Divididos < (SELECT COUNT(*) FROM @Items_Dividir))
	BEGIN
		SET @Cant_Items_Divididos += 1

		-- MODIFICO ITEM PRINCIPAL A MAXIMO DE IMPORTE
		SET @Item_Dividir = (SELECT Item_Tar_Lote FROM @Items_Dividir WHERE Item_Tabla = @Cant_Items_Divididos)

		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Cant_Items_Divididos: ' + CONVERT(VARCHAR(25),@Cant_Items_Divididos)
			PRINT 'Actualizo el importe del item original en Val_Tarjetas_Lotes_Items al importe máximo por item: ' + CONVERT(VARCHAR(25),@pMax_Importe)
		END

		UPDATE Val_Tarjetas_Lotes_Items SET Importe = @pMax_Importe WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item = @Item_Dividir AND Importe > 0
		UPDATE Val_Tarjetas_Lotes_Items SET Importe_2Vto = @pMax_Importe WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item = @Item_Dividir AND Importe_2Vto > 0
		UPDATE Val_Tarjetas_Lotes_Items SET Importe_3Vto = @pMax_Importe WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item = @Item_Dividir AND Importe_3Vto > 0

		WHILE((SELECT Importe FROM @Items_Dividir WHERE Item_Tabla = @Cant_Items_Divididos) > @pMax_Importe)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Mientras que el importe secundario siga siendo mayor que el máximo permitido por item, desgloso el item original'
			END

			SET @Prox_Item = (SELECT MAX(Item) + 1 FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote)
			
			UPDATE @Items_Dividir SET Importe = (Importe - @pMax_Importe) WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item_Tabla = @Cant_Items_Divididos AND Importe > 0
			UPDATE @Items_Dividir SET Importe_2Vto = (Importe_2Vto - @pMax_Importe) WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item_Tabla = @Cant_Items_Divididos AND Importe_2Vto > 0
			UPDATE @Items_Dividir SET Importe_3Vto = (Importe_3Vto - @pMax_Importe) WHERE Id_Tar_Lote = @pId_Tar_Lote AND Item_Tabla = @Cant_Items_Divididos AND Importe_3Vto > 0

			SELECT @Importe = Importe,
				   @Importe2 = Importe_2Vto,
				   @Importe3 = Importe_3Vto
				   FROM @Items_Dividir
				   WHERE Item_Tabla = @Cant_Items_Divididos

			IF(@Importe > @pMax_Importe)
			BEGIN
				SET @Importe = @pMax_Importe
			END
			
			IF(@Importe2 > @pMax_Importe)
			BEGIN
				SET @Importe2 = @pMax_Importe
			END

			IF(@Importe3 > @pMax_Importe)
			BEGIN
				SET @Importe3 = @pMax_Importe
			END

			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Inserto en tabla Val_Tarjetas_Lotes_Items'
				PRINT '@Importe: ' + CONVERT(VARCHAR(25),@Importe) + '. @Importe2: ' + CONVERT(VARCHAR(25),@Importe2) + '. @Importe3: ' + CONVERT(VARCHAR(25),@Importe3)
				PRINT '@Prox_Item: ' + CONVERT(VARCHAR(25),@Prox_Item)
			END

			INSERT INTO Val_Tarjetas_Lotes_Items (Id_Tar_Lote, Item, Id_Cliente, Id_Trans, Nro, Descripcion, Importe, 
												  Estado, Nota, Cuit, Fecha_Est, Importe_2Vto, Importe_3Vto)

										   SELECT Id_Tar_Lote, @Prox_Item, Id_Cliente, Id_Trans, Nro, Descripcion, @Importe, 
												  Estado, Nota, Cuit, Fecha_Est, @Importe2, @Importe3 
													FROM @Items_Dividir
													WHERE Item_Tabla = @Cant_Items_Divididos
	    END
	END

	--------------------------------------------- FIN SEPARO LOS ITEMS  ----------------------------------------

	--------------------------------------------- REORDENO LOS ITEMS  ----------------------------------------

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Reordeno la columna Item en tabla Val_Tarjetas_Lotes_Items para el lote'
	END

	SELECT * INTO #Val_Tarjetas_Lotes_Items_AUX FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote ORDER BY Id_Cliente, Id_Trans
	DELETE FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote

	ALTER TABLE #Val_Tarjetas_Lotes_Items_AUX ADD Item_Ordenado INT IDENTITY(1,1)
	UPDATE #Val_Tarjetas_Lotes_Items_AUX SET Item = Item_Ordenado
	ALTER TABLE #Val_Tarjetas_Lotes_Items_AUX DROP COLUMN Item_Ordenado 

	INSERT INTO Val_Tarjetas_Lotes_Items SELECT * FROM #Val_Tarjetas_Lotes_Items_AUX

	--------------------------------------------- FIN REORDENO LOS ITEMS  ----------------------------------------

	--------------------------------------------- ACTUALIZO VALORES DEL LOTE  ----------------------------------------

	UPDATE Val_Tarjetas_Lotes SET Cantidad = (SELECT COUNT(*) FROM Val_Tarjetas_Lotes_Items WHERE Id_Tar_Lote = @pId_Tar_Lote) WHERE Id_Tar_Lote = @pId_Tar_Lote

	--------------------------------------------- FIN ACTUALIZO VALORES DEL LOTE  ----------------------------------------

	IF @pFlagUsarTrans <> 0 AND @@TRANCOUNT > 0
	BEGIN
		COMMIT
	END

	IF @pOmitir_Resultado_OK = 0
	BEGIN
		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,0				AS ErrorMessage
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Generacion_Moratoria'
	END
	
END TRY
BEGIN CATCH

	IF EXISTS (SELECT 1 FROM @Respuesta_)
	BEGIN
		SELECT * FROM @Respuesta_
	END
	ELSE
	BEGIN
		EXECUTE usp_GetErrorInfo
	END

	IF @pFlagUsarTrans <> 0 AND @@TRANCOUNT > 0
	BEGIN
		ROLLBACK
	END

	RETURN 9999

END CATCH